﻿(function ($) {
    $.widget("a4.a4unsavedChanges", {
        options: {
            elements: ":input:not(input[type=submit]):not(input[type=button])",
            buttons: ":submit,.h-reloadFormButton",
            ignoreDisabledElements: false,
            ignoreHiddenElements: false,
            promptWhenLeavingPage: false,
            promptMessage: "You have unsaved changes in your page"
        },
        _create: function () {
            this.element.attr("data-tracking-changes", true);

            this._initializeItemsData();

            this._bindEvents();
        },
        _initializeItemsData: function () {
            var self = this;

            this.itemsData = [];

            this.forceChanges = false;
            this.hasChanges = false;

            $(this.options.elements, this.element).each(function () {
                self.itemsData.push({ Hash: self._getInputHash($(this)), OriginalValue: self._getInputValue($(this)), HasChanges: false, Element: $(this) });
            });

            this._trigger("ready", null, { buttons: $(this.options.buttons) });
        },
        _addItem: function (item) {

        },
        destroy: function () {
            this.element.removeAttr("data-tracking-changes");

            $(document).off("click.unsavedChanges");
            $(window).off("beforeunload.unsavedChanges");

            $.Widget.prototype.destroy.call(this);
        },
        _getInputHash: function (input) {
            var inputHash = input.attr("Id") + "_" + input.attr("Name");
            var type = input.attr('type');

            if (type == "checkbox" || type == "radio") {
                inputHash += "_" + input.attr("Value");
            }

            return inputHash;
        },
        _getInputValue: function (input) {
            return a4.getInputValue(input);
        },
        _compareValues: function (input) {
            var self = this;
            var inputHash = self._getInputHash(input);
            var itemData = _.find(self.itemsData, function (d) { return d.Hash == inputHash; });

            if (itemData) {
                itemData.HasChanges = itemData.OriginalValue != self._getInputValue(input);

                //Check other changed
                if (!itemData.HasChanges) {
                    _.each(self.getChangedItems(), function (i) {
                        i.HasChanges = i.OriginalValue != self._getInputValue(i.Element);
                    });
                }
            }
            else {
                self.itemsData.push({ Hash: self._getInputHash(input), OriginalValue: self._getInputValue(input), HasChanges: true, Element: input });
            }

            self.checkChanges();
        },
        _bindEvents: function () {
            var self = this;

            this.element.on("keyup change", this.options.elements, function (e) {
                self._compareValues($(this));
            });

            $(document).on("click.unsavedChanges", self.options.buttons, function (e) {
                self.reset();
            });

            if (this.options.promptWhenLeavingPage) {
                $(window).on("beforeunload.unsavedChanges", function (e) {
                    if (self.hasChanges) {
                        return self.options.promptMessage;
                    }
                });
            }
        },
        getChangedItems: function () {
            return _.filter(this.itemsData, function (d) { return d.HasChanges; });
        },
        reset: function () {
            this._initializeItemsData();
            this._trigger("reset", null, { hasChanges: false });
        },
        checkChanges: function () {
            var changedItems = this.getChangedItems();
            var hasChanges = this.forceChanges || (changedItems && changedItems.length > 0);

            this.element.toggleClass("has-changes", hasChanges);

            this.hasChanges = hasChanges;

            this._trigger("change", null, { buttons: $(this.options.buttons), hasChanges: hasChanges, changedItems: changedItems });
        },
        change: function () {
            this.forceChanges = true;
            this.hasChanges = true;

            this._trigger("change", null, { buttons: $(this.options.buttons), hasChanges: true });
        },
        hasChangedItems: function () {
            return this.hasChanges;
        }
    });
}(jQuery));